/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.launching;

import com.aptana.php.debug.core.launch.ScriptLocator;
import com.aptana.php.debug.core.launch.remote.RemoteDebugRedirector;
import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.core.tunneling.SSHTunnel;
import com.aptana.php.debug.core.util.NameValuePair;
import com.aptana.webserver.core.IServer;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.daemon.DebugDaemon;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org2.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org2.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;

public class XDebugWebLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(final ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String[] startStopURLs;
        IProject proj;
        String fileName;
        IServer server;
        block26: {
            if (!DebugDaemon.getDefault().validateCommunicationDaemons("org2.eclipse.php.debug.core.xdebugDebugger")) {
                monitor.setCanceled(true);
                monitor.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            if (mode.equals("debug") && XDebugLaunchListener.getInstance().isWebLaunchActive()) {
                this.displayErrorMessage(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_0);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            server = PHPServersManager.getServer((String)configuration.getAttribute("ATTR_SERVER_NAME", ""));
            if (server == null) {
                Logger.log(4, "Launch configuration could not find server (server name = " + configuration.getAttribute("ATTR_SERVER_NAME", "") + ')');
                this.displayErrorMessage(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_1);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            fileName = ScriptLocator.getScriptFile((ILaunchConfiguration)configuration, (String)"ATTR_SERVER_FILE_NAME");
            if (fileName == null) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                boolean specificFileLaunch = configuration.getAttribute("ATTR_USE_SPECIFIC_FILE", false);
                if (specificFileLaunch) {
                    this.displayErrorMessage("Could not launch the session. \nMake sure that the selected script exists in your project");
                } else {
                    this.displayErrorMessage("Could not launch the session. \nMake sure that a script is visible in your PHP editor");
                }
                return;
            }
            Path filePath = new Path(fileName);
            proj = null;
            try {
                proj = ResourcesPlugin.getWorkspace().getRoot().getProject(filePath.segment(0));
            }
            catch (Throwable t) {
                if (proj != null) break block26;
                Logger.logException("Could not execute the debug (Project is null).", t);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
        }
        if ("debug".equals(mode) && !PHPLaunchUtilities.checkIsStandardPort("org2.eclipse.php.debug.core.xdebugDebugger")) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        String project = proj.getFullPath().toString();
        wc.setAttribute("org2.eclipse.php.debug.core.PHP_Project", project);
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(proj));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(proj));
        wc.doSave();
        boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(proj);
        stopAtFirstLine = wc.getAttribute("firstLineBreakpoint", stopAtFirstLine);
        boolean useInternalBrowser = launch.getLaunchConfiguration().getAttribute("org2.eclipse.php.debug.core.UseExternalBrowser", false);
        String baseURL = new String(configuration.getAttribute("ATTR_SERVER_BASE_URL", "").getBytes());
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        final Exception[] exception = new Exception[1];
        final IWebBrowser[] browser = new IWebBrowser[1];
        if (useInternalBrowser) {
            String title = baseURL;
            try {
                URL url = new URL(title);
                title = "Debug - /" + url.getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            final String internalBrowserTitle = title;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        browser[0] = PHPLaunchUtilities.openInternalBrowser(internalBrowserTitle);
                        Browser.clearSessions();
                    }
                    catch (PartInitException e) {
                        Logger.logException("Error initializing the web browser.", e);
                        exception[0] = e;
                    }
                }
            });
        } else {
            browser[0] = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
        }
        DBGpElement target = null;
        SSHTunnel tunnel = null;
        if (mode.equals("debug")) {
            String sessionId = DBGpSessionHandler.getInstance().generateSessionId();
            String ideKey = null;
            if (DBGpProxyHandler.instance.useProxy()) {
                ideKey = DBGpProxyHandler.instance.getCurrentIdeKey();
                if (!DBGpProxyHandler.instance.registerWithProxy()) {
                    this.displayErrorMessage(String.valueOf(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_2) + DBGpProxyHandler.instance.getErrorMsg());
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    return;
                }
            } else {
                ideKey = DBGpSessionHandler.getInstance().getIDEKey();
            }
            startStopURLs = this.generateStartStopDebugURLs(baseURL, sessionId, ideKey, configuration);
            tunnel = PHPLaunchUtilities.getSSHTunnel(configuration);
            if (XDebugPreferenceMgr.useMultiSession()) {
                target = new DBGpMultiSessionTarget(launch, fileName, startStopURLs[1], ideKey, stopAtFirstLine, browser[0], sessionId);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
                launch.addDebugTarget((IDebugTarget)target);
            } else {
                target = new DBGpTarget(launch, fileName, startStopURLs[1], ideKey, stopAtFirstLine, browser[0], sessionId);
                target.setPathMapper(PathMapperRegistry.getByServer(server));
            }
            DBGpSessionHandler.getInstance().addSessionListener((IDBGpSessionListener)((Object)target));
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = baseURL;
            startStopURLs = stringArray;
        }
        final String startURL = startStopURLs[0];
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
        subMonitor.beginTask(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_3, 10);
        final SSHTunnel sshTunnel = tunnel;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    final List postData = configuration.getAttribute("ATTR_HTTP_POST", Collections.EMPTY_LIST);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (sshTunnel != null) {
                                    sshTunnel.connect();
                                }
                                if (postData != null && !postData.isEmpty()) {
                                    new RemoteDebugRedirector().redirect(browser[0], new URL(startURL), postData);
                                } else {
                                    browser[0].openURL(new URL(startURL));
                                }
                            }
                            catch (Exception e) {
                                Logger.logException("Error initializing the web browser.", e);
                                exception[0] = e;
                            }
                        }
                    });
                }
                catch (Exception t) {
                    Logger.logException("Error initializing the web browser.", t);
                    exception[0] = t;
                }
            }
        });
        subMonitor.worked(10);
        if (exception[0] == null) {
            if (mode.equals("debug")) {
                launch.addDebugTarget((IDebugTarget)target);
                subMonitor.subTask(PHPDebugCoreMessages.XDebug_WebLaunchConfigurationDelegate_4);
                target.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), monitor);
            } else {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            }
        } else {
            Logger.logException("we have an exception on the browser", exception[0]);
            if (mode.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener((IDBGpSessionListener)((Object)target));
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
        subMonitor.done();
    }

    protected void displayErrorMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_debugError, (String)message);
            }
        });
    }

    public String[] generateStartStopDebugURLs(String baseURL, String sessionId, String ideKey, ILaunchConfiguration configuration) throws CoreException {
        String[] startStopURLs = new String[2];
        StringBuilder baseUrlBuilder = new StringBuilder(baseURL);
        if (baseUrlBuilder.indexOf("?") > -1) {
            baseUrlBuilder.append('&');
        } else {
            baseUrlBuilder.append('?');
        }
        List requestParameters = configuration.getAttribute("ATTR_HTTP_GET", Collections.EMPTY_LIST);
        try {
            for (String pair : requestParameters) {
                NameValuePair nameValuePair = NameValuePair.fromPairString((String)pair);
                if (nameValuePair == null) continue;
                baseUrlBuilder.append(URLEncoder.encode(nameValuePair.name, "UTF-8")).append('=').append(URLEncoder.encode(nameValuePair.value, "UTF-8"));
                baseUrlBuilder.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.php.debug.epl", e.getMessage(), (Throwable)e));
        }
        baseURL = baseUrlBuilder.toString();
        startStopURLs[0] = String.valueOf(baseURL) + "XDEBUG_SESSION_START=" + ideKey + "_" + sessionId;
        startStopURLs[1] = String.valueOf(baseURL) + "XDEBUG_SESSION_STOP_NO_EXEC=" + ideKey + "_" + sessionId;
        return startStopURLs;
    }
}

